// JavaScript Document
$(function() {
    // URLパラメータから言語を取得
	lang = getKey("lang");

	// 開いているhtmlファイル名を取得
	var fileName = window.location.href.split('/').pop();
	
	// ファイルの種類 (list* | list_doc*)
	var sort = fileName.split('.')[0];
	sort = sort.split('_')[1] == "doc" ? "doc" : "";

	// xmlからファイルの有無を確認
	$.ajax({
		url: "data_list.xml",
		async: false,
		cache: false,
		dataType: "xml",
		error: function(){
			alert("Error loading XML document");
		},
		success: parseXml
	});

	// XMLパース用関数
	function parseXml(xml, status){
		if(status!='success')return;
		
		$(xml).find("item").each(function() {
			// id属性から、対応する要素を得る
			var id = $(this).attr("id");
			var myDom = document.getElementById(id);
		
			// 動画の有無をチェックし、styleを適用
			var movie = $(this).children('movie').text();
			// ファイルなし
			if(movie == "0") {
				$(myDom).find(".movie").addClass("style-none");
			// ファイルあり
			}else if(movie == "1"){
				$(myDom).find(".movie").addClass("style-dl");
			}
			// pdfの有無をチェック、styleを適用
			$(this).children('pdf').each(function() {
				if($(this).attr('lang') == lang) {
					// ファイルなし
					if($(this).text() == "0") {
						if(sort == "doc") {
							$(myDom).addClass("style-none");
						}else {
							$(myDom).find(".doc").addClass("style-none");
						}
					// ファイルあり、最新
					}else if($(this).text() == "1") {
						// 取説リスト
						if(sort == "doc") {
							$(myDom).addClass("style-dl");
							$(myDom).append("<div class=\"style-dl\"></div>");
						// 作例集
						}else {
							$(myDom).find(".doc").append("<div class=\"style-dl " + lang + "\"></div>");
							$(myDom).find(".doc").addClass("style-dl");
						}
					// ファイルあり、古い
					}else {
						// 取説リスト
						if(sort == "doc") {
							var myLink = $(myDom).find("a").attr('href');
									$(myDom).append("<div class=\"update\"><a href=\"update/" + myLink + "\"><img src=\"img/update.gif\" /></a></div>");
				
						// 作例集
						}else {
							var myLink = $(myDom).find(".doc").find("a").attr('href');
							$(myDom).find(".doc").append("<div class=\"update\"><a href=\"update/" + myLink + "\"><img src=\"img/update.gif\" /></a></div>");

					
						
						}
					}
				}
			});	
		});
	}
});

function getKey(key){
	var str = location.search.substring(1);
	if(str){
		var x = str.split("&");
		for(var i=0; i < x.length; i++) {
			var y=x[i].split("=");
			if(y[0] == key) return y[1];
		}
		return "";
	}else {
		return "";
	}
}
